<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       https://foxpost.hu
 * @since      1.0.0
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/public/partials                        
 */
  
  $currentLanguage = get_bloginfo('language'); 
    
  $aptData = Foxpost_Wc_Shipping::getAptData();  
  
  $name = $id = $class = "foxpost_wc_shipping_apt_selector";
  $selected_apt = WC()->session->get('selected_foxpost_wc_shipping_apt');
  if ( empty($selected_apt) ) $selected_apt['operator_id'] = (array)Foxpost_Wc_Shipping::getFromSession('shipping_apt', null);
 
  $select = '<select name="' . $name . '" id="' . $id . '" class="' . $class . '">';
  $select .= '<optgroup label=""><option>' . __('Kérjük válasszon egy csomagautomatát', 'foxpost-shipping-method') . '</option></optgroup>';
  $city   = '';
  foreach ($aptData as $apt) {
      $aptId = $apt->operator_id;
      if ($city !== $apt->city) {
          if ($city !== '') {
              $select .= '</optgroup>';
          }
          $select .= '<optgroup label="' . esc_html($apt->city) . '">';
      }                                                                                                                       
      $selected = (!is_null($selected_apt) && isset($selected_apt['operator_id']) && $apt->operator_id==$selected_apt['operator_id']) ? 'selected="selected"' : '';
      $select .= '<option value="' . esc_attr($aptId) . '" '.$selected.'>' . esc_html($apt->name).', '. esc_html($apt->zip).'</option>';
      $city   = $apt->city;
  }
  if ($city !== '') {
      $select .= '</optgroup>';
  }
  $select .= '</select>';
 
?>                                       
<tr>
    <th><?php echo esc_html(__( 'Parcel locker' ) , 'foxpost-shipping-method');?></th>
    <td data-title="<?php echo esc_attr(__( 'Parcel locker' ) , 'foxpost-shipping-method');?>">
		<?php if('foxpost_wc_shipping_apt_shipping' == $selected_method): ?>                                                                                                                 
                                                                                                        
            <p><?php echo wp_kses($select, array('select' => array('name' => array(), 'id' => array(), 'class' => array()), 'option' => array('value' => array(), 'selected' => array()), 'optgroup' => array('label' => array())));?></p>
            <p>
            <?php if (!empty($apt_address)) echo esc_html__( 'Address', 'woocommerce' ).": " . esc_html($apt_address) . "<br/>";?>
            <?php if (get_option('foxpost_wc_shipping_map_enabled')=='yes') 
            printf( '<a href="#" class="foxpost-wc-shipping-map-button" data-modal-iframe="https://cdn.foxpost.hu/apt-finder/v1/app/?lang=%s&discount=1&noHeader=1&noAptCount=1">%s</a>',
            $currentLanguage, 
            esc_html__( 'Map',  'foxpost-shipping-method') , 
            'foxpost-wc-shipping'); ?>
            </p>
            
            <?php if (get_option('foxpost_wc_shipping_map_enabled')=='yes') {?> 
            <div class="f-wc-s-window-modal f-wc-s-js-modal-window f-wc-s-js-window-overlay">
            	<div class="f-wc-s-window-modal__in f-wc-s-js-modal-window-in"></div>
            </div> 
            <?php };?>
                        
		<?php endif; ?>             
    </td>
</tr>

