import Select from 'react-select';
import { useEffect, useState, useRef } from 'react';
import { __ } from '@wordpress/i18n';
import { registerPlugin } from '@wordpress/plugins';
jQuery( document ).ready( function () {
	const { useSelect } = window.wp.data;
	const { __ } = window.wp.i18n;
	const { ExperimentalOrderShippingPackages } = window.wc.blocksCheckout;
	const { Button, Spinner } = window.wc.blocksComponents;

	const render = () => {
		const defaultApm = window.selectedApm || null;
		const [ apms, setApms ] = useState( () => [] );
		const [ selectedApm, setSelectedApm ] = useState( () => {return "hu769"} );
		const [ apmList, setApmList ] = useState( () => [] );
		const [ showMap, setShowMap ] = useState( () => false );

		useEffect( () => {
			window.addEventListener( 'message', setApmToWooCommerce );

			if ( apms.length <= 0 ) fetchApmList();
			if ( apmList.length === 0 && apms.length > 0 ) generateApmList();
			return () =>
				window.removeEventListener( 'message', setApmToWooCommerce );
		}, [ apms, selectedApm, apmList ] );

		const fetchApmList = () => {
			fetch( 'https://cdn.foxpost.hu/foxpost_terminals_extended_v3.json' )
				.then( ( response ) => response.json() )
				.then( ( data ) => {
					setApms( data );
				} );
		};

		const generateApmList = () => {
			const mapped = Object.keys( apms )
				.reduce( ( array, key ) => {
					return [
						...array,
						{
							label: `${ apms[ key ][ 'name' ] } (${ apms[ key ][ 'address' ] })`,
							value: apms[ key ][ 'operator_id' ],
						},
					];
				}, [] )
				.sort( ( a, b ) => ( a.label > b.label ? 1 : -1 ) );
			if(defaultApm){
				setSelectedApm(defaultApm)
			}	
			setApmList( mapped );
		};

		const isFoxpostSelected = useSelect( ( select ) => {
			const store = select( 'wc/store/cart' );
			const selected_shipping = store
				.getCartData()
				.shippingRates[ 0 ].shipping_rates.filter(
					( sr ) =>
						sr.selected &&
						sr.method_id.includes(
							'foxpost_wc_shipping_apt_shipping'
						)
				);
			return selected_shipping.length > 0;
		} );
		const setApmToWooCommerce = ( e ) => {
			let apmId = null;
			if ( e.data ) {
				const parsed = JSON.parse( e.data );
				if ( 'operator_id' in parsed ) {
					apmId = parsed.operator_id;
				}
			} else {
				apmId = e.value;
			}
			if ( selectedApm == apmId ) return;
			window.wp
				.apiFetch( {
					url:blockCheckoutHelper?.ajax_url,
					method: 'POST',
					headers: {
						'Content-Type': 'application/x-www-form-urlencoded',
					},
					body: new URLSearchParams({
						page: 'checkout',
						action: 'foxpost_wc_shipping_select', 
						apt: apmId,
						security: blockCheckoutHelper?.nonce
					}),
				} )
				.then( ( response ) => {
					let index = apmList.findIndex(
						( apt ) => apt.value === apmId
					);
					setSelectedApm( apmList[ index ] );
					if ( e.data ) setShowMap( ! showMap );
				} );
		};
		const MapSelectorFrame = () => {
			const frameSrc = 'https://cdn.foxpost.hu/apt-finder/v1/app/';
			return <iframe src={ frameSrc } width="100%" height="800"></iframe>;
		};
		const FoxComponent = () => (
			<ExperimentalOrderShippingPackages>
				<div>
					<div>
						{ __(
							'Kérjük válasszon egy csomagautomatát',
							'foxpost-wc-shipping'
						) }
					</div>
					<div
						style={ {
							display: 'flex',
							alignItems: 'center',
							margin: '1em 0',
						} }
					>
						<span style={ { marginRight: 'auto' } }>
							{ __(
								'Kiválasztott automata',
								'foxpost-wc-shipping'
							) }
						</span>
						<Select
							onChange={ setApmToWooCommerce }
							options={ apmList }
							isSearchable={ true }
							isMulti={ false }
							placeholder={ __(
								'Kérjük válasszon egy csomagautomatát',
								'foxpost-wc-shipping'
							) }
							value={ selectedApm }
						/>
					</div>
					<div>
						<Button
							onClick={ ( e ) => {
								e.preventDefault();
								setShowMap( ! showMap );
							} }
							width="100%"
						>
							{ __(
								'Automata kiválasztása térképről',
								'foxpost-wc-shipping'
							) }
						</Button>

						<div>
							{ showMap && <MapSelectorFrame></MapSelectorFrame> }
						</div>
					</div>
				</div>
			</ExperimentalOrderShippingPackages>
		);

		return isFoxpostSelected && <FoxComponent></FoxComponent>;
	};

	registerPlugin( 'foxpost-wc-shipping-dropdown', {
		render,
		scope: 'woocommerce-checkout',
	} );
} );
