<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://foxpost.hu
 * @since      1.0.0
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/public
 * @author     Foxpost.hu <b2chelpdesk@foxpost.hu>
 */
class Foxpost_Wc_Shipping_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $foxpost_wc_shipping    The ID of this plugin.
	 */
	private $foxpost_wc_shipping;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $foxpost_wc_shipping       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $foxpost_wc_shipping, $version ) {
		$this->foxpost_wc_shipping = $foxpost_wc_shipping;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
		wp_enqueue_style( $this->foxpost_wc_shipping.'',         plugin_dir_url( __FILE__ ) . 'css/foxpost-wc-shipping-public.css', array(), $this->version, 'all' );
 		//wp_enqueue_style( $this->foxpost_wc_shipping.'-select2', plugin_dir_url( __FILE__ ) . 'css/select2.min.css', array(), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 */                                                                                             
	public function enqueue_scripts() {
 		if(WC_Blocks_Utils::has_block_in_page( wc_get_page_id('checkout'), 'woocommerce/checkout' )){
            $script_asset_path = plugin_dir_path( __FILE__ ) . 'checkout/index.asset.php';
            $script_asset      = require( $script_asset_path );
            $script_url =  plugin_dir_url( __FILE__ ) . 'checkout/index.js';
            wp_enqueue_script( $this->foxpost_wc_shipping.'-checkout', $script_url, $script_asset['dependencies'], $script_asset['version'] );
        } else {
            wp_enqueue_script( $this->foxpost_wc_shipping.'-modal',   plugin_dir_url( __FILE__ ) . 'js/foxpost-wc-shipping-modal.js', array( 'jquery' ), $this->version, false );
            //wp_enqueue_script( $this->foxpost_wc_shipping.'-select2', plugin_dir_url( __FILE__ ) . 'js/select2.full.min.js', array( 'jquery' ), $this->version, false );
            wp_enqueue_script( $this->foxpost_wc_shipping,            plugin_dir_url( __FILE__ ) . 'js/foxpost-wc-shipping-public.js', array( 'jquery' ), $this->version, false );
            $data = [
                'lang' => get_bloginfo('language'),
            ];
            wp_enqueue_script( $this->foxpost_wc_shipping.'-apt-selector', plugin_dir_url( __FILE__ ) . 'js/foxpost-wc-shipping-apt-selector.js', array( 'jquery' ), $this->version, false );
            wp_add_inline_script($this->foxpost_wc_shipping.'-apt-selector', 'const aptSelector = ' . wp_json_encode($data) , 'before');
        }
	}
    
    /**
     * Runs when a point is selected from the map
     * 
     * 
     */ 
	public function select_apt_with_ajax() {       
        $apt_id = sanitize_text_field($_POST['apt']);
        
		//Use the already existing woocommerce nonce, so we don't need to create one just for this
		if($_POST['page'] == 'checkout') {
			check_ajax_referer( 'update-order-review', 'security' );
		} else {
			check_ajax_referer( 'update-shipping-method', 'security' );
		}
        
        $apt = Foxpost_Wc_Shipping::isValidAptId($apt_id);   
                
                
        //At now dont check the APTid is valid or not 
		if( $apt!==false ) {
			//Store it in the checkout session.
			WC()->session->set('selected_foxpost_wc_shipping_apt', (array)$apt ); //$_POST['apt'] 
            Foxpost_Wc_Shipping::setToSession('shipping_apt',      (array)$apt ); //$_POST['apt']
                 
			//And return the point, maybe processing is done in JS
			wp_send_json_success(array('apt' => $apt));

		} else {

			//Return error if it doesn't exists
			wp_send_json_error();

		}        
                       
    }

    /**
     * When user is logged in set APT to sessinon from user meta data
     * @param array $post_data 
     */
	public function shipping_method_selected( $post_data ) { 
        if ( is_null(WC()->session) ) return;  //longtime session...
        
		//Check if the user is signed in
		if(is_user_logged_in()) {
            $customer_id = get_current_user_id();   
			$place_id = get_user_meta( $customer_id, '_foxpost_wc_shipping_aptid', true ); //    var_dump($place_id);
			//if ( !is_null(WC()->session) ) $selected_pont = WC()->session->get( 'foxpost_place_id' );            
            if ( !is_null(WC()->session) && $place_id!='' ) WC()->session->set('foxpost_aptid', $place_id);
		}   

 		//Get selected shipping methd
		$chosen_methods = WC()->session->get( 'chosen_shipping_methods' ); 
    } 

    /**
     * Checkout the order....
     * @param int $order_id Order id.
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function save_checkout( $order_id ) {
        
		//If we have a pont selected, that means we need to save it
		$chosen_methods   = WC()->session->get( 'chosen_shipping_methods' );
		//$selected_pont    = WC()->session->get( 'selected_foxpost_wc_shipping_apt' ); //apt array
        $selected_pont     = (array)Foxpost_Wc_Shipping::getFromSession('shipping_apt', null);
		$chosen_method    = $chosen_methods[0];
                                                                      
        $order = $order_id instanceof WC_Order ? $order_id : wc_get_order( $order_id );  
		if(strpos($chosen_method, 'foxpost_wc_shipping_apt_shipping') !== false && $selected_pont) {    

			//Save custom meta and replace shipping address
			$this->update_order_with_selected_point($order, $selected_pont);
                                                                                   
			// Get the customer id
			$customer_id = $order->get_customer_id();

			//Save user meta if the customer was signed in
			if( ! empty($customer_id) && $customer_id != 0) {
				update_user_meta( $customer_id, '_foxpost_wc_shipping_aptid', $selected_pont['operator_id'] );
			}
            $order->update_meta_data( '_foxpost_wc_shipping_method', 'apt' );
            $order->update_meta_data( 'foxpost_wc_shipping_barcode', '' );
            $order->update_meta_data( '_foxpost_wc_shipping_status', 0 );        
            $order->update_meta_data( '_foxpost_wc_shipping_error', '' );  
            $order->update_meta_data( '_foxpost_wc_shipping_parcel_status', '' );  
            $order->update_meta_data( '_foxpost_wc_shipping_parcel_status_name', __( 'Unkown', 'foxpost-shipping-method'));      
            $order->update_meta_data( 'foxpost_wc_shipping_parcel_size', get_option('foxpost_wc_shipping_default_parcel_size') );  
 
		}elseif( strpos($chosen_method, 'foxpost_wc_shipping_hd_shipping') !== false) {
            $order->update_meta_data( '_foxpost_wc_shipping_method', 'hd' );      
            $order->update_meta_data( 'foxpost_wc_shipping_barcode', '' );
            $order->update_meta_data( '_foxpost_wc_shipping_status', 0 );        
            $order->update_meta_data( '_foxpost_wc_shipping_error', '' );  
            $order->update_meta_data( '_foxpost_wc_shipping_parcel_status', '' );  
            $order->update_meta_data( '_foxpost_wc_shipping_parcel_status_name', __( 'Unkown', 'foxpost-shipping-method'));  
            $order->update_meta_data( 'foxpost_wc_shipping_parcel_size', get_option('foxpost_wc_shipping_default_parcel_size') );  
        }else{
        
        }
    
        $order->save();
        
        //in case of next order the user have to select apt
        (array)Foxpost_Wc_Shipping::removeFromSession('shipping_apt', null);
	}
    
    
    /**
     * Save seleceted APT to order meta data
     * 
     * @param $order Order
     * @param $point Selected APT  
     */   
	public function update_order_with_selected_point($order, $point) {      
		$address = array(
			'first_name' => '',
			'last_name'  => '',
			'company'    => $point['name'],
			'email'      => '',
			'phone'      => '',
			'address_1'  => $point['street'], // street|address
			'address_2'  => '',
			'city'       => $point['city'],
			'state'      => '',
			'postcode'   => $point['zip'],
			'country'    => 'HU'
		);

		//If the point contain country
		if(isset($point['country'])) {
			$address['country'] = $point['country'];
		}
                                    
		//Set shipping address to the same as the apt's address
		$order->set_address( $address, 'shipping' );

		//Store APT custom meta
		$order->update_meta_data( '_foxpost_wc_shipping_apt_id', $point['operator_id'] );       //place_id
		$order->update_meta_data( '_foxpost_wc_shipping_apt_name', $point['name'] );
		$order->update_meta_data( '_foxpost_wc_shipping_apt_coordinates', $point['geolat'].';'.$point['geolng'] ); 
		//And save the order
		$order->save();
	}
    
    
    /**
     * Checkout validation 
     * Weight validation 
     * Locker validation
     * Mobile number validation 
     */    
    public function after_checkout_validation($fields, $errors){            
		$chosen_methods   = WC()->session->get( 'chosen_shipping_methods' );  //var_dump($chosen_methods);exit("*$chosen_methods*"); 
        $chosen_method    = isset($chosen_methods[0]) ? $chosen_methods[0] : false;
        if (!$chosen_method)  return false;
        $selected_pont    = (array)Foxpost_Wc_Shipping::getFromSession('shipping_apt', null);

        list($chosen_method,$instance) = explode(':', $chosen_method);
    
        //Its our shipping
        if ( strpos($chosen_method, 'foxpost_wc_shipping_') === 0 ){        
            //Weight check
            $shipping_methods = WC()->shipping()->get_shipping_methods();   
            foreach($shipping_methods as $instance=>$shipping_method){                                        
                if ( $shipping_method->id == $chosen_method){         
                    $shipping_method->instance_id = $instance;
                    $shipping_method->init();
                                                                       
                    if (isset($shipping_method->max_weight)) {
                        if ($shipping_method->max_weight > 0) {
                            $total_weight = WC()->cart->get_cart_contents_weight();                              
                            $weight_unit = get_option('woocommerce_weight_unit');
                            if($weight_unit == "g") $total_weight = $total_weight / 1000;
                            if ($total_weight > $shipping_method->max_weight) {
                                /* translators: %1$s: weight of parcel %2$s: weight of shopping cart */
                                $errors->add( 'validation', sprintf(__('The maximum weight of a parcel is %1$s kg, but %1$s kg in the basket.','foxpost-shipping-method'), $shipping_method->max_weight, $total_weight));
                                return false;
                            }
                        }
                    } 
                            
                } 
            }
    
            //Locker req
    		if(strpos($chosen_method, 'foxpost_wc_shipping_apt_shipping') !== false && empty($selected_pont)) { 
                $errors->add( 'validation', __( "Please select parcel locker!", 'foxpost-shipping-method'));
            }
            
            //Mobile number req
            if (!isset($fields['billing_phone']) || empty($fields['billing_phone'])) {
                $errors->add('validation', __('Please provide a mobile phone number', 'foxpost-shipping-method'));
            } else {
                if (!preg_match(apply_filters('foxpost_wc_shipping_get_phone_number_regex', '/^\+36\d{2}\d{7}$/'), $fields['billing_phone'])) {
                    $errors->add('validation', __('Please provide a valid mobile phone number', 'foxpost-shipping-method'));
                }
            }  
        }
        
        return true;         
    }

        
    
    /**
     * woocommerce_cart_totals_after_shipping
     * 
     * 
     */         
	public function wctas() {
    }    
    
    /**
     * woocommerce_before_shipping_calculator
     * 
     * 
     */ 
	public function wbsc() {
    } 
    
    /**
     * woocommerce_after_shipping_calculator
     * 
     * 
     */ 
	public function wasc() {     
		$chosen_methods = WC()->session->chosen_shipping_methods;
                                             
		//Show only if option is enabled in customizer
		if( /*is_cart() &&*/ $this->_isSelected($chosen_methods) ) {
            $this->add_codfee();
            
            $method = explode(':', $chosen_methods[0]);

            //Get selected APT
            $selected_apt = (array)WC()->session->get('selected_foxpost_wc_shipping_apt');
            //$apt_address = (is_null($selected_apt)) ? '' : $selected_apt['address'];     
            $apt_address = (empty($selected_apt)) ? '' : $selected_apt['address'];
        
                    
			//Use wc_get_template, so it can be overwritten from a theme if needed
			wc_get_template('foxpost-wc-shipping-map.php', array(
				'selected_method' => $method[0],
				'apt_address' => $apt_address,
			), false, plugin_dir_path(__FILE__) . '/partials/');
		}
    }   
    
    /**
     * Add shipping fee to card if COD payment selected. 
     * 
     * 
     */
    public function add_codfee(){
        //Get payment method
        $payment_method = WC()->session->get('chosen_payment_method');

        $cod = get_option('woocommerce_cod_settings', array() );    //print_r($codfee) ; exit;
        $codtitle = (isset($cod['title'])) ? $cod['title'] : '';

        //$this->get_option('enabled');
        $codfee = get_option('foxpost_wc_shipping_codfee', array('limit'=>0, 'fee'=>0) ); //print_r( $codfee ) ; exit;

        $chosen_methods = WC()->session->chosen_shipping_methods;

        //echo WC()->cart->get_subtotal().'::'.WC()->cart->get_total().'::'.WC()->cart->get_shipping_total();

        $total = WC()->cart->get_subtotal() + WC()->cart->get_subtotal_tax(); //???
        //$total = (int)WC()->cart->get_total() - (int)WC()->cart->get_shipping_total();  echo $total;exit("*$total*");

        $all_tax_rates = [];
        $tax_classes = WC_Tax::get_tax_classes();
        if ( !in_array( '', $tax_classes ) ) {
            array_unshift( $tax_classes, '' );
        }
        foreach ( $tax_classes as $tax_class ) {
            $taxes = WC_Tax::get_rates_for_tax_class( $tax_class );
            $all_tax_rates = array_merge( $all_tax_rates, $taxes );
        }
        if( !isset($all_tax_rates[0]))
            $tax_rate = '1.27';
        else
            $tax_rate = '1.'.$all_tax_rates[0]->tax_rate;

        if (    $this->_isSelected($chosen_methods) &&
            $total < (int)$codfee['limit'] &&
            'cod'==$payment_method )
            /* translators: %s: cod fee */
            WC()->cart->add_fee( sprintf(__('%s fee', 'foxpost-shipping-method'), $codtitle), (float)($codfee['fee']/(float)$tax_rate), true);

    }

    /**
     * Trigger update_checkout when payment method changed.
     * 
     * @see woocommerce_review_order_before_payment hook
     */
    public function refresh_checkout_on_payment_methods_change(){
        echo "
        <script type=\"text/javascript\">
            (function($){
                $( 'form.checkout' ).on( 'change', 'input[name^=\"payment_method\"]', function() { 
                    $('body').trigger('update_checkout');
                });
            })(jQuery);
        </script>
        ";
    }    
    
    /**
     * Check the selected shipping method is our.
     * 
     * @param $chosen_methods Methods
     * @return boolean 
     */    
    private function _isSelected($chosen_methods){
    
		$is_selected = false;
		if($chosen_methods) {
			foreach ($chosen_methods as $chosen_method) {
				if(strpos($chosen_method, 'foxpost_wc_shipping_') !== false) {  //.....apt_shipping OR .......hd_shipping
					$is_selected = true;
				}
			}
		}
        return $is_selected;   
    } 

    public function add_foxpost_selected_apt_endpoint(){
        register_rest_route( 'foxpost-wc-shipping/v1', '/selected-apt', array(
            'methods'  => WP_REST_Server::CREATABLE,
            'callback' => [$this,'add_selected_apt_to_wc_session'],
            'permission_callback' => '__return_true',
        ) );
    }

    public function add_selected_apt_to_wc_session(WP_REST_Request $request){
        $data = $request->get_json_params();
        $apt = Foxpost_Wc_Shipping::isValidAptId($data['apt']);   
        Foxpost_Wc_Shipping::setToSession('shipping_apt', $apt);
        return rest_ensure_response($request);
    }
    public function hide_shipping_method_based_on_weight($rates){
        $cart_weight = WC()->cart->get_cart_contents_weight();
        foreach($rates[0]['rates'] as $index => $r) {
            $options = get_option(sprintf("woocommerce_%s_%d_settings", $r->method_id, $r->instance_id));
            if(isset($options['max_weight'])){
                if( $cart_weight > $options['max_weight']){
                    unset($rates[0]['rates'][$index]);
                }
            }
        }
        return $rates;
    }
}   //end class
