<?php

if (!defined('ABSPATH')) {
    die;
}
/**
 * Adds compatiblity fow WooCommerce HPOS
 * @see https://woocommerce.com/document/high-performance-order-storage/
 * This class defines all code necessary to implement HPOS functions.
 *
 * @since      1.0.9
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/includes
 * @author     Foxpost.hu <b2chelpdesk@foxpost.hu>
 */

class Foxpost_Wc_Shipping_HPOS
{
    public $hpos_enabled = false;
    public function __construct()
    {
        if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
            if (\Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled()) {
                $this->hpos_enabled = true;
            }
        }
    }

    /**
     * Set HPOS compatibility if WooCommerce supports it
     * @return void
     */
    public function add_hpos_compatibility(): void
    {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', 'foxpost-wc-shipping/foxpost-wc-shipping.php', true);
    }

    /**
     * Get order metadata based on key, checks if HPOS is in use or not
     * @param WC_Order $order
     * @param string $key
     * @param bool $is_single
     * 
     * @return mixed
     */
    public function get_order_metadata(WC_Order $order, $key, $is_single)
    {
        if ($this->hpos_enabled) {
            return $order->get_meta($key, $is_single);
        } else {
            return get_post_meta($order->get_id(), $key, $is_single);
        }
    }


    /**
     * Checks if order will be delivered with FoxPost
     * @param int|string $post_id
     * 
     * @return bool
     */
    public function is_foxpost_parcel($post_id): bool
    {
        $orderId = sanitize_text_field($post_id);
        $order = wc_get_order($orderId);
        if (!$order)
            return false;
        $meta = $this->get_order_metadata($order, '_foxpost_wc_shipping_method', true);
        if ($meta && !is_null($meta) && $meta !== false && strlen($meta) > 0)
            return true;
        return false;
    }

    public function getOrderByBarcode($barcode): ?WC_Order
    {
        return  wc_get_orders([
            'limit' => 1,
            'meta_key' => 'foxpost_wc_shipping_barcode',
            'meta_value' => $barcode
        ])[0];
    }
}
