<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://foxpost.hu
 * @since             1.0.0
 * @package           Foxpost_Wc_Shipping
 * @author     Foxpost.hu <b2chelpdesk@foxpost.hu>
 *
 * @wordpress-plugin
 * Plugin Name:       FOXPOST - Packeta Group
 * Plugin URI:        https://foxpost.hu/uzleti-partnereknek/integracios-segedlet#woocommerce-plugin
 * Description:       Csomagszállítás egyszerűen, rugalmasan, környezettudatosan és érintkezésmentesen.
 * Version:           1.0.20
 * Author:            Foxpost
 * Author URI:        https://foxpost.hu/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       foxpost-shipping-method
 * Domain Path:       /languages
 * Requires PHP:      5.6
 * Requires at least: 5.9.4
 * Tested up to:      6.7
 * WC requires at least: 6.8.2
 * WC tested up to:   9.0.0
 * Requires Plugins:  woocommerce
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('FOXPOST_WC_SHIPPING_VERSION', '1.0.20' );
define('FOXPOST_WC_SHIPPING_MIN_PHP_VERSION', '5.6');
define('FOXPOST_WC_SHIPPING_MIN_WP_VERSION', '5.9.4'); //nincs lejebb tesztelve
define('FOXPOST_WC_SHIPPING_MIN_WOO_VERSION', '5.0.0');

/**
 * Check dependencies (PHP, WordPres, WooCommerce)
 */
require_once( 'includes/class-foxpost-wc-shipping-dependencies.php' );



/**
 * Test WooCommerce is active, if not active dont DIE, silent ignore
 */
if ( ! fws_is_woocommerce_active() ) {    
    //wp_die( __( 'My Plugin requires WooCommerce!', 'foxpost-wc-shipping' ) );
    return;
}

/*
function foxpost_wc_shipping_info_update_message( $plugin_file, $plugin_data, $status ) {
    echo '<tr class="active"><td>&nbsp;</td><td colspan="2"><p style="background-color: #d54e21; padding: 10px; color: #f9f9f9; margin-top: 10px"><strong>Important Notice!</strong></td></tr>';
}
$path = plugin_basename( __FILE__ );
add_action( "after_plugin_row_{$path}", 'foxpost_wc_shipping_info_update_message', 10, 3 );
*/

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-foxpost-wc-shipping-activator.php
 */
function fws_activate_foxpost_wc_shipping() { 
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-foxpost-wc-shipping-activator.php';
	Foxpost_Wc_Shipping_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-foxpost-wc-shipping-deactivator.php
 */
function fws_deactivate_foxpost_wc_shipping() {
    if ( ! fws_is_woocommerce_active() ) return;
    
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-foxpost-wc-shipping-deactivator.php';
	Foxpost_Wc_Shipping_Deactivator::deactivate();
}

register_activation_hook    ( __FILE__, 'fws_activate_foxpost_wc_shipping' );
register_deactivation_hook  ( __FILE__, 'fws_deactivate_foxpost_wc_shipping' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require_once plugin_dir_path( __FILE__ ) . 'includes/class-foxpost-wc-shipping-logger.php' ;
require_once plugin_dir_path( __FILE__ ) . 'includes/class-foxpost-wc-shipping.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/class-foxpost-wc-shipping-scheduler.php' ;
require_once plugin_dir_path( __FILE__ ) . 'includes/class-foxpost-wc-shipping-hpos.php' ;
if( !class_exists( 'WP_Filesystem_Direct' ) ) {
    require_once ABSPATH . 'wp-admin/includes/file.php';
    // require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';
	WP_Filesystem();
}
/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function fws_run_foxpost_wc_shipping() {
	$plugin = new Foxpost_Wc_Shipping();
	$plugin->run();
}
if ( fws_is_woocommerce_active() ) add_action('woocommerce_loaded', 'fws_run_foxpost_wc_shipping');
