<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       http://example.com
 * @since      1.0.4
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/admin/partials
 */



if (!defined('ABSPATH')) {
    exit();
} 

$parcel_vs_order = get_option('foxpost_wc_shipping_parcel_vs_order', array());

$parcel_vs_order['foxpost'][] = '';
$parcel_vs_order['wc'][] = 'no-action';

//print_r($parcel_vs_order);exit;

$rows = '';
foreach($parcel_vs_order['foxpost'] as $key=>$parcel_status ){
    $wc     =  fws_wc_options( $parcel_vs_order['wc'][$key] );    
    $fox    =  fws_foxpost_options( $parcel_status );       
    $rows  .= fws_tmpl($fox, $wc, $key);
} 





function fws_wc_options($selected='') {
    $opts = '';
    foreach(Foxpost_Wc_Shipping_Admin::wc_get_order_statuses() as $k=>$v){
        $sh = ($selected===$k) ? 'selected="selected"' : '';   
        $opts .= '<option value="' . esc_attr($k) . '" ' . $sh . '>' . esc_html($v) . '</option>'; 
    } 
    return $opts;
}


function fws_foxpost_options($selected='') {    
    $opts = '';
    $statusConfig = Foxpost_Wc_Shipping::loadConfig()['FoxpostParcelStatusToOrderStatus'];
    foreach($statusConfig as $k => $v){
        if (is_array($v)){
            $sh = ($selected==$k) ? 'selected="selected"' : '';   
            $opts .= '<option value="' . esc_attr($k) . '" ' . $sh . '>'. esc_html__(sprintf("%s", $k), 'foxpost-shipping-method') . "*</option>"; 
        }else{
            $sh = ($selected==$v) ? 'selected="selected"' : '';  
            $opts .= '<option value="' . esc_attr($v) . '" ' . $sh . '>'. esc_html__(sprintf("%s", $v), 'foxpost-shipping-method') . " (" . esc_html($v) . ")</option>";     
        }
    
    }
    $opts = '<option value="">' . esc_html__('-=Please select=-', 'foxpost-shipping-method') . '</option>' . $opts;
    return $opts;
}

function fws_tmpl($foxpost='', $wc='', $key=0) {
   $key_sanitized = absint($key);
   $tmpl = '
<tr>
<td width="49%">
<select name="foxpost_wc_shipping_parcel_vs_order[foxpost][]" autocomplete="off" id="foxpost_wc_shipping_parcel_vs_order_foxpost' . $key_sanitized . '">' . $foxpost . '</select>
</td>   
<td width="2%">
<span class="dashicons dashicons-arrow-right-alt2" style="margin-top: 5px;"></span>
</td>
<td width="49%">
<select name="foxpost_wc_shipping_parcel_vs_order[wc][]" autocomplete="off" id="foxpost_wc_shipping_parcel_vs_order_wc' . $key_sanitized . '">' . $wc . '</select>
</td>                                        
</tr>
  ';
                                            
    return $tmpl;  
}
          
?>
			<tr valign="top">
				<th scope="row" class="titledesc">
				<label><?php echo esc_html( $value['title'] ); ?> <?php /*echo $foxpost_wc_shipping_testbutton_tooltip_html . $disabled_message;*/ ?></label>
			</th>
				<td class="forminp">
			     <table class="wc_gateways widefat foxpost_wc_shipping" cellspacing="0" >
                    <thead>
                        <tr><th><?php echo esc_html__( 'Foxpost pracel status', 'foxpost-shipping-method');?></th><th></th><th><?php echo esc_html__('WooCommerce order status', 'foxpost-shipping-method');?></th></tr>
                    </thead>
					<tbody>
  					<?php echo $rows;?>
                    </tbody>
				</table>
                <p class="description"><?php echo esc_html( $value['desc'] );?></p>
				</td>
			</tr>
