<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
/**
 * 
 * The admin-specific functionality of the plugin.
 *
 * @link       https://foxpost.hu/
 * @since      1.0.0
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/admin
 */
 
require_once (dirname(plugin_dir_path(__FILE__)))
            . '/includes/abstract-foxpost-wc-shipping-method.php';        
             
require_once (dirname(plugin_dir_path(__FILE__)))
            . '/includes/FoxPostApi.php';
         
require_once dirname(dirname(plugin_dir_path(__FILE__)))
            .'/woocommerce/woocommerce.php';     
   
    
             
/**
 * _foxpost_wc_shipping_status:
 * 0 alap
 * 1 elküldve van barcode
 * 2 nyomtatva
 * 3 feladva?
 *
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/admin
 * @author     Foxpost.hu <b2chelpdesk@foxpost.hu>
 */
class Foxpost_Wc_Shipping_Admin{

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $foxpost_wc_shipping    The ID of this plugin.
	 */
	private $plugin_name; 

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	private $logger;
    private $FoxPostApi = null;     
    private $API_LOG_LEVEL = 2;
    
    private Foxpost_Wc_Shipping_HPOS $hpos;
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $foxpost_wc_shipping       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {    
		$this->plugin_name = $plugin_name;
		$this->version = $version; 
		$this->logger = new Foxpost_Wc_Shipping_Logger();
        $this->hpos = new Foxpost_Wc_Shipping_HPOS();
        add_action('init', array($this, 'includes'));     
	}

    /**
     * Include any classes we need within admin.
     */
    public function includes()
    {
        include_once dirname(__FILE__) . '/class-foxpost-wc-shipping-admin-notice.php';
    }

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Foxpost_Wc_Shipping_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Foxpost_Wc_Shipping_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/foxpost-wc-shipping-admin.css', array(), $this->version, 'all' );
        
        //Check if the the scheduled actions is loaded to action-scheduler.
        Foxpost_Wc_Shipping_Scheduler::schedule_actions();

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Foxpost_Wc_Shipping_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Foxpost_Wc_Shipping_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name.'-countdown', plugin_dir_url( __FILE__ ) . 'js/jquery.countdown.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/foxpost-wc-shipping-admin.js', array( 'jquery' ), $this->version, false );
		
		// Add nonce for admin AJAX calls
		wp_localize_script( $this->plugin_name, 'foxpost_admin_ajax', array(
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'nonce'    => wp_create_nonce( 'foxpost_admin_nonce' )
		) );
        
        #after shipping partial
        global $theorder;
        if($theorder instanceof WC_Order){
            $data = [
                'printLabel'=> __('Print label', 'foxpost-shipping-method'),
                'orderId'=>$theorder->get_id(),
                'nonce' => wp_create_nonce( 'foxpost_admin_nonce' ),
                'ajaxUrl' => admin_url( 'admin-ajax.php' )
            ];
            wp_enqueue_script( $this->plugin_name.'-after-shipping', plugin_dir_url( __FILE__ ) . 'js/partials/after-shipping.js', array( 'jquery' ), $this->version, false );
            wp_add_inline_script($this->plugin_name.'-after-shipping', 'const d = ' . wp_json_encode($data), 'before');
        }
        if(get_current_screen()->id == "woocommerce_page_wc-settings" && isset($_GET['tab'])) {
            if(sanitize_key($_GET['tab']) == 'foxpost_wc_shipping' ) {
                # last log
                $logfiles = scandir(trailingslashit( WC_LOG_DIR ), 0);   
                foreach ($logfiles as $k=>$logfile){ 
                    $lastlog = 'foxpost-wc-shipping-'.gmdate('Y-m-d').'-';
                    if (preg_match("/^$lastlog(.*)/i", $logfile)) {
                        break;
                    }    
                }

                $data = [
                    'logName'=>$logfile,
                ];

                wp_enqueue_script( $this->plugin_name.'-last-log', plugin_dir_url( __FILE__ ) . 'js/partials/last-log.js', array( 'jquery' ), $this->version, false );
                wp_add_inline_script($this->plugin_name.'-last-log', 'const lastLog = ' . wp_json_encode($data), 'before');

                #test button
                wp_enqueue_script( $this->plugin_name.'-test-button', plugin_dir_url( __FILE__ ) . 'js/partials/test-button.js', array( 'jquery' ), $this->version, false );
                wp_localize_script( $this->plugin_name.'-test-button', 'foxpost_admin_ajax', array(
                    'ajax_url' => admin_url( 'admin-ajax.php' ),
                    'nonce'    => wp_create_nonce( 'foxpost_admin_nonce' )
                ) );

                #status selector
                $parcel_vs_order = get_option('foxpost_wc_shipping_parcel_vs_order', array());
                $parcel_vs_order['foxpost'][] = '';
                $parcel_vs_order['wc'][] = 'no-action';
                foreach($parcel_vs_order['foxpost'] as $key=>$parcel_status ){
                    $wc     =  $this->__wc_options( $parcel_vs_order['wc'][$key] );    
                    $fox    =  $this->__foxpost_options( $parcel_status );
                } 
                $data = [
                    'last' => count($parcel_vs_order['wc']) - 1, 
                    'wc' => $wc,
                    'fox' => $fox,
                ];
                wp_enqueue_script( $this->plugin_name.'-status-selector', plugin_dir_url( __FILE__ ) . 'js/partials/status-selector.js', array( 'jquery' ), $this->version, false );
                wp_add_inline_script($this->plugin_name.'-last-log', 'const statusSelector = ' . wp_json_encode($data), 'before');
            }
        }
        
    }
    private function __wc_options($selected='') {
        $opts = '';
        foreach(Foxpost_Wc_Shipping_Admin::wc_get_order_statuses() as $k=>$v){
            $sh = ($selected===$k) ? 'selected="selected"' : '';   
            $opts .= "<option value=\"$k\" $sh>$v</option>"; 
        } 
        return $opts;
    }
    
    private function __foxpost_options($selected='') {    
        $opts = '';
        $lali = Foxpost_Wc_Shipping::loadConfig()['FoxpostParcelStatusToOrderStatus'];
        
        foreach($lali as $k=>$v){       
            
            if (is_array($v)){
                $sh = ($selected==$k) ? 'selected="selected"' : '';   
                $opts .= '<option value="'.$k.'" '.$sh.'>'.__($k, 'foxpost-shipping-method')."*</option>"; 
            }else{
                $sh = ($selected==$v) ? 'selected="selected"' : '';  
                $opts .= '<option value="'.$v.'" '.$sh.'>'.__($v)." ($v, 'foxpost-shipping-method')</option>";     
            }
        
        }
        $opts = '<option value="">'.__('-=Please select=-', 'foxpost-shipping-method').'</option>'.$opts;
        return $opts;
    }

    /**
     * Add new setting tab.
     *
     * @param array $settings_tabs
     *
     * @since 1.0.0
     *
     * @return array
     */
    public function woo_add_settings_tab($settings_tabs)
    {
        $settings_tabs['foxpost_wc_shipping'] = __('FoxPost');

        return $settings_tabs;
    }
    
    
    /**
     * Output the settings.
     *
     * @since 1.0.0
     */
    public function woo_settings_tabs_settings()
    {
        woocommerce_admin_fields($this->get_settings());
    }    
    
    
    /**
     * Saves settings.
     *
     * @since 1.0.0
     */
    public function woo_settings_save()
    {   
        global $current_section, $current_tab;
        
        
        //	$value = apply_filters( "woocommerce_admin_settings_sanitize_option_$option_name", $value, $option, $raw_value );
        foreach ( $_POST['foxpost_wc_shipping_parcel_vs_order']['wc'] as $k=>$v){
             if ( $v=='no-action' || $_POST['foxpost_wc_shipping_parcel_vs_order']['foxpost'][$k]=='' ){ 
                unset($_POST['foxpost_wc_shipping_parcel_vs_order']['wc'][$k]);
                unset($_POST['foxpost_wc_shipping_parcel_vs_order']['foxpost'][$k]);
             } 
        }
    
        woocommerce_update_options($this->get_settings());
        
        if ($current_section) {
            do_action('woocommerce_update_options_foxpost_wc_shipping_' . $current_section);
        }
    }


    

	//Generate html for custom settings fields
	public function render_custom_setting_html($data) {    
		//$field_key = $this->get_field_key( $key );
		$defaults = array(
			'title' => '',
			'disabled' => false,
			'class' => '',
			'css' => '',
			'placeholder' => '',
			'type' => 'text',
			'desc_tip' => false,
			'description' => '',
			'custom_attributes' => array(),
			'options' => array()
		);
		$value = wp_parse_args( $data, $defaults );
        $template_name = $data['type'];
                                                              
		ob_start();
		include( dirname( __FILE__ ) . '/partials/html-admin-'.str_replace('_', '-', $template_name).'.php' );     
        $html = ob_get_clean();
        echo $html;
		//return ob_get_clean();
	}  
    
    /**
     * Gets settings.
     *
     * @since 1.0.0
     *
     * @return array
     */
    public function get_settings()
    {                   
        $settings = array(    
            'section_title' => array(
                'name' => __('General'),
                'type' => 'title',
                'desc' => '',
                'id' => 'foxpost_wc_shipping_section_title',
            ),
            'username' => array(
                'name' => __('Foxpost API username', 'foxpost-shipping-method'),
                'type' => 'text',
                'desc' => __('If you provide a Foxpost API username you will be able to send parcels to Foxpost API.', 'foxpost-shipping-method'),
                'id' => 'foxpost_wc_shipping_username',
            ),
            'password' => array(
                'name' => __('Foxpost API password', 'foxpost-shipping-method'),
                'type' => 'text',
                'desc' => __('If you provide a Foxpost API password you will be able to send parcels to Foxpost API.', 'foxpost-shipping-method'),
                'id' => 'foxpost_wc_shipping_password',
            ),
            'apikey' => array(
                'name' => __('Foxpost API key', 'foxpost-shipping-method'),
                'type' => 'text',
                'desc' => __('If you provide a Foxpost API KEY you will be able to send parcels to Foxpost API.', 'foxpost-shipping-method'),
                'id' => 'foxpost_wc_shipping_apikey',
            ),           
            'testbutton' => array(
                'name' => __('Foxpost API test', 'foxpost-shipping-method'),
                'type' => 'testbutton',
            ),                      
         
         	'label_size' => array(
        		'type' => 'select',
        		'class' => 'wc-enhanced-select',
        		'title' => __( 'Label size' , 'foxpost-shipping-method'), 
        		'options' => Foxpost_Wc_Shipping_Method::getLabelSizes(),       
                'default' => Foxpost_Wc_Shipping_Method::getDefaultLabelSize(),  
        		'desc' => __( 'One label size on printed page.' , 'foxpost-shipping-method'),
                'id' => 'foxpost_wc_shipping_label_size',
        	),  
            
            'default_parcel_size' => array(
                'type'    => 'select',
                'title'   => __('Default parcel size', 'foxpost-shipping-method'),
                'default' => Foxpost_Wc_Shipping_Method::getDefaultParcelSize(),
                'options' => Foxpost_Wc_Shipping_Method::getParcelSizes(),
                'id' => 'foxpost_wc_shipping_default_parcel_size',
            ), 
            
            'codfee' => array(
            	'title' => __( 'COD fee' , 'foxpost-shipping-method'),
            	'type' => 'codfee',
            	'desc' => __( 'Fee when COD payment method selected. Please add value with TAX!' , 'foxpost-shipping-method'),
                'id' => 'foxpost_wc_shipping_codfee',   
                //'default' => array('limit'=>20000, 'fee'=>250),
                'default' => array( 'limit' =>Foxpost_Wc_Shipping::loadConfig()['FoxpostParcelCODFeeDefauts'][0], 
                                    'fee'   =>Foxpost_Wc_Shipping::loadConfig()['FoxpostParcelCODFeeDefauts'][1]
                                ),       
            ),           
            'seller_email_message'     => array(
                'type'          => 'textarea',
                'title'         => __('Order email message', 'foxpost-shipping-method'),
                'desc'          => __('This message put order email, after order table. HTML is applicable.', 'foxpost-shipping-method'),
                'id'            => 'foxpost_wc_shipping_seller_email_message',
                'default'       => '',
                'placeholder'   => __('This message put order email, after order table. HTML is applicable.', 'foxpost-shipping-method'),
                'desc_tip'      => true,
            ),
            'relabel'      => array(
                'title'   => __('Generate PDF label', 'foxpost-shipping-method'),
                'type'    => 'checkbox',
                'label'   => __('Yes/No', 'foxpost-shipping-method'),
                'id'      => 'foxpost_wc_shipping_relabel',  
                'default' => 'yes',
                'desc' => __( 'If enabled then available generate PDF stickers more that once.' , 'foxpost-shipping-method'), 
            ),       
            'reparcel'      => array(
                'title'   => __('Export CSV and send to Foxpost API', 'foxpost-shipping-method'),
                'type'    => 'checkbox',
                'label'   => __('Yes/No', 'foxpost-shipping-method'),
                'id'      => 'foxpost_wc_shipping_reparcel',  
                'default' => 'no',
                'desc' => __( 'If enabled then available to Foxpost API/CSV more that once.' , 'foxpost-shipping-method'), 
            ),                 

         	'map_enabled' => array(
        		'title'   => __( 'Foxpost map enable' , 'foxpost-shipping-method'), 
        		'type'    => 'checkbox',
                'label'   => __('Yes/No', 'foxpost-shipping-method'),
                'id'      => 'foxpost_wc_shipping_map_enabled',    
                'default' => 'yes',  
        		'desc'    => __( 'If enabled then show map(link) on checkout.' , 'foxpost-shipping-method'), 
        	),   

         	'parcel_vs_order' => array(
        		'type' => 'status-selector',
        		'class' => 'wc-enhanced-select',
        		'title' => __( 'Order status change' , 'foxpost-shipping-method'), 
        		'options' => Foxpost_Wc_Shipping_Admin::wc_get_order_statuses(),       
                'default' => 'no-action',  
        		'desc' => __( 'Set what that you will.' , 'foxpost-shipping-method'), 
                'id' => 'foxpost_wc_shipping_parcel_vs_order',
        	),    
                        
            'log'      => array(
                'title'   => __('Log files', 'foxpost-shipping-method'),             
                'type'    => 'button',
                'label'   => __('See last logfile', 'foxpost-shipping-method'),                   
                'id'      => 'foxpost_wc_shipping_viewlog',
                'default' => 'no',
                'value'   => '/wp-admin/admin.php?page=wc-status&tab=logs',
                'desc'    => sprintf('<a href="/wp-admin/admin.php?page=wc-status&tab=logs">%s</a>', __('All log see on WooCommerce->Status->Logs tab.', 'foxpost-shipping-method') ), 
            ),                    

            'section_end' => array(
                'type' => 'sectionend',
                'id' => 'foxpost_wc_shipping_section_end',
            )
        );

        
        return apply_filters('woocommerce_get_settings_foxpost_wc_shipping', $settings);
    }
    
    
    
    /**
     * Add NEW shipping methods.
     *
     * @param array $methods
     *
     * @since 1.0.0
     *
     * @return array
     */
    public function define_shipping_methods($methods)
    {
        if (is_null($methods)) $methods = array();
        $methods = array_merge($methods,
            Foxpost_Wc_Shipping_Method::getAvailableShippingMethodsForRegister()
        );

        return $methods;
    }
    /**
     * _foxpost_wc_shipping_apt_id, _foxpost_wc_shipping_apt_name, _foxpost_wc_shipping_apt_coordinates, 
     * _foxpost_wc_shipping_status: 0......
     * _foxpost_wc_shipping_method: hd|apt
     * 
     */ 
    public function woocommerce_admin_order_data_after_shipping_address($order)
    {
        global $pagenow, $post_type;                     
        // WooCommerce 9 compatibility
        $valid_post = false;        
        if($this->hpos->hpos_enabled)
            $valid_post = ($pagenow == 'admin.php' && ($_REQUEST['page'] === 'wc-orders' && $_REQUEST['action'] === 'edit'));
        else
            if ('post.php'==$pagenow && 'shop_order'==$post_type) $valid_post = true;
        
        if( !$order->get_meta('_foxpost_wc_shipping_status', false) ) $valid_post = false;
        
        if( !$valid_post ) return;
        $data = array(
            'order_id'      => $order->get_id(),
            'method'        => $order->get_meta('_foxpost_wc_shipping_method'),
            'method_str'    => ('apt'==$order->get_meta('_foxpost_wc_shipping_method')) ? __('Foxpost parcel locker shipping', 'foxpost-shipping-method') : __('Foxpost home delivery shipping', 'foxpost-shipping-method'),
            'barcode'       => $order->get_meta('foxpost_wc_shipping_barcode'), 
            'error'         => $order->get_meta('_foxpost_wc_shipping_error' ), 
            'tracelink'     => sprintf(FoxPostApi::TRACEURL, $order->get_meta('foxpost_wc_shipping_barcode'))
        );

        wc_get_template('html-admin-order-data-after-shipping-address.php', $data, false, plugin_dir_path(__FILE__) . '/partials/');        
                
    }    
    
    /**
     * Add 'foxpost_wc_shipping_seller_email_message' and trace link to emails.
     * 
     * 
     * 
     * 
     */
    public function email_after_order_table($order, $sent_to_admin, $plain_text, $email){
        
        if( !$order->get_meta('foxpost_wc_shipping_barcode', false) ) return;
        
        $data = array(
            'order_id'              => $order->get_id(),
            'barcode'               => $order->get_meta('foxpost_wc_shipping_barcode'),
            'tracelink'             => sprintf(FoxPostApi::TRACEURL, $order->get_meta('foxpost_wc_shipping_barcode')),
            'seller_email_message'  => get_option('foxpost_wc_shipping_seller_email_message')
        );
		
        wc_get_template('html-admin-email-after-order-table.php', $data, false, plugin_dir_path(__FILE__) . '/partials/');           
    }    
    
    /**
     * Call scheduler by hand
     * 
     * @see Foxpost_Wc_Shipping_Scheduler 
     */ 
    public function sync_parcel_status(){  
        // Security check
        check_ajax_referer( 'foxpost_admin_nonce', 'nonce' );
        
        // Capability check
        if ( ! current_user_can( 'manage_woocommerce' ) ) {
            wp_send_json_error( array( 'message' => __('Permission denied', 'foxpost-shipping-method') ) );
        }
        
        $this->logger->log_i( 'Sync parcel statuses by hand' );  
        $s = new Foxpost_Wc_Shipping_Scheduler();
        $updatedOrders = $s->get_parcel_state();
        $time = ($updatedOrders==false) ? 0 : (Foxpost_Wc_Shipping::SYNC_MIN_MINUTE*60);
        
        if ($updatedOrders==false){
            wp_send_json_error  ( array('time'=>0, 'orders'=>0, 'message'=>'Jelenleg nincs releváns rendelés!') );
        }else{
            wp_send_json_success( array('time'=>$time, 'orders'=>$updatedOrders) );   
        }
 
    }                                                        
    
    
    
    public function get_parcel_addresses(){
        // Security check
        check_ajax_referer( 'foxpost_admin_nonce', 'nonce' );
        
        // Capability check
        if ( ! current_user_can( 'manage_woocommerce' ) ) {
            wp_send_json_error( array( 'msg' => __('Permission denied', 'foxpost-shipping-method') ) );
        }
        
        // Validate and sanitize input
        if ( ! isset( $_POST['username'] ) || ! isset( $_POST['password'] ) || ! isset( $_POST['apikey'] ) ) {
            wp_send_json_error( array( 'msg' => __('Missing required fields', 'foxpost-shipping-method') ) );
        }
        
        $username   = sanitize_text_field( wp_unslash( $_POST['username'] ) ); 
        $password   = sanitize_text_field( wp_unslash( $_POST['password'] ) ); 
        $apikey     = sanitize_text_field( wp_unslash( $_POST['apikey'] ) ); 
                        
        $FoxPostApi = new FoxPostApi(5); 
        $FoxPostApi->setCred($username, $password, $apikey);  
        $status = $FoxPostApi->login();
        
        //wp_send_json_error( mixed $data = null, int $status_code = null, int $options )  
        if ($status!==true) wp_send_json_error  (array('msg' => __('Login error!','foxpost-shipping-method')), 200);
        else                wp_send_json_success(array('msg' => __('Login successful!','foxpost-shipping-method')), 200);
    }

    /**
     * Get Parcel status from API, return to AJAX and save to metadata.
     * 
     * 
     */ 
    public function get_parcel_status(){
        // Security check
        check_ajax_referer( 'foxpost_admin_nonce', 'nonce' );
        
        // Capability check
        if ( ! current_user_can( 'manage_woocommerce' ) ) {
            wp_send_json_error( array( 'message' => __('Permission denied', 'foxpost-shipping-method') ) );
        }
        
        // Validate input
        if ( ! isset( $_POST['barcode'] ) ) {
            wp_send_json_error( array( 'message' => __('Missing barcode', 'foxpost-shipping-method') ) );
        }
        
        $barcode = sanitize_text_field( wp_unslash( $_POST['barcode'] ) ); 
        
        //$FoxPostApi = new FoxPostApi(6);  
        //$FoxPostApi->setCred( get_option('foxpost_wc_shipping_username'), get_option('foxpost_wc_shipping_password'), get_option('foxpost_wc_shipping_apikey') );  
        $FoxPostApi = $this->getAPI(); 
        $parcelStatus = $FoxPostApi->parcelStatus($barcode); //var_dump($status);   var_dump($FoxPostApi);

        if($FoxPostApi->error==true){
            $this->logger->log_e( "\n".$FoxPostApi->getLog() );   
            wp_send_json_error();
        }
 
        $order = $this->hpos->getOrderByBarcode($barcode);
        if($order){
            $order->update_meta_data('_foxpost_wc_shipping_parcel_status_name', $parcelStatus->shortName);
            $order->save();
            wp_send_json_success(array('status' => $parcelStatus->shortName));        
        }
        else{
            wp_send_json_success(array('status' => $parcelStatus->shortName));
        }
           
    }


    /**
     * Get PDF from API and send back with ajax response 
     * AJAX
     * 
     */
    public function get_parcel_label(){
        // Security check
        check_ajax_referer( 'foxpost_admin_nonce', 'nonce' );
        
        // Capability check
        if ( ! current_user_can( 'manage_woocommerce' ) ) {
            wp_send_json_error( array( 'message' => __('Permission denied', 'foxpost-shipping-method') ) );
        }
        
        // Validate input
        if ( ! isset( $_POST['post_id'] ) ) {
            wp_send_json_error( array( 'message' => __('Missing order ID', 'foxpost-shipping-method') ) );
        }
        
        $orderId = absint( $_POST['post_id'] );
       
        $is_foxpost_parcel = $this->hpos->is_foxpost_parcel($orderId);
       
        if (!$is_foxpost_parcel) {
                $this->logger->log_e( "#$orderId is not Foxpost parcel, metadata '_foxpost_wc_shipping_method' not exists" );
                wp_send_json_error( "#$orderId is not Foxpost parcel" );
        } 
        
        $order = wc_get_order( $orderId );
        
        $status = $this->hpos->get_order_metadata($order,'_foxpost_wc_shipping_status', true);
        $barcode = $this->hpos->get_order_metadata($order,'foxpost_wc_shipping_barcode', true);
        
        
        
        //some error or what?
        if (1==$status && empty($barcode)){
          $order->update_meta_data( '_foxpost_wc_shipping_status', 0 );              
          $order->save();            
        }                                            
                  
        //Print
        //parcelLabel($barcodes=array(), $pageSize='A7', $startPos=0){
        if (!empty($barcode) && (1==$status || get_option('foxpost_wc_shipping_relabel')=='yes' )  ){                    
        
            //$FoxPostApi = new FoxPostApi(6);  
            //$FoxPostApi->setCred(get_option('foxpost_wc_shipping_username'), get_option('foxpost_wc_shipping_password'), get_option('foxpost_wc_shipping_apikey') );                             
            //$p = wp_upload_dir( null, false ); //print_r($p);                      
            //$FoxPostApi->setTmpDir( $p['basedir'].DIRECTORY_SEPARATOR.'foxpost-wc-shipping'.DIRECTORY_SEPARATOR );
            
            $FoxPostApi = $this->getAPI(); 

            $pdf_name = $FoxPostApi->parcelLabel( array($barcode), get_option('foxpost_wc_shipping_label_size') );//  var_dump($parcel);   var_dump($FoxPostApi);        

            if($FoxPostApi->error==true){
                $this->logger->log_e( "\n".$FoxPostApi->getLog() );   
                wp_send_json_error("API error");
            }


            $order->update_meta_data( '_foxpost_wc_shipping_status', 2 );              
            $order->save();      
            
            $p = wp_upload_dir( null, false );          
            if (!$pdf_name) wp_send_json_error("foxpost_wc_shipping_relabel not enabled");
            else            wp_send_json_success(array('pdf_location' => $p['baseurl'].'/foxpost-wc-shipping/labels/'.$pdf_name));
        }
  
        //Send Parcel data to API if no $barcode OR foxpost_wc_shipping_reparcel=yes
        if (empty($barcode) && (0==$status || get_option('foxpost_wc_shipping_reparcel')=='yes' )  ){
            $shipping_method = ( 'apt' == $this->hpos->get_order_metadata($order, '_foxpost_wc_shipping_method', true) && !empty($this->hpos->get_order_metadata($order,'_foxpost_wc_shipping_apt_id', true)) ) ? 'apt' : 'hd';                                                          
         
            $parcels[] = $this->_convOrder2ParcelData($order);  
            
            //$FoxPostApi = new FoxPostApi(6);  
            //$FoxPostApi->setCred( get_option('foxpost_wc_shipping_username'), get_option('foxpost_wc_shipping_password'), get_option('foxpost_wc_shipping_apikey') );
            $FoxPostApi = $this->getAPI(); 
             
            $result = $FoxPostApi->createParcel( $parcels );       
            
    		if($FoxPostApi->error==true) {
                if(isset($FoxPostApi->error_msgs[$orderId])){
                    $msg = $FoxPostApi->error_msgs[$orderId];
                    if(strpos($msg, 'INVALID_APM_ID') != false){ 
                         wp_send_json_error(array('barcode' => 'Nem megfelelő automata!' ), 400);      
                    }
                }
                if(strlen($FoxPostApi->error_msg) > 0){
                    if(strpos($FoxPostApi->error_msg, 'recipientPhone') !== false){ 
                        wp_send_json_error(array('barcode' => 'Hiányzó telefonszám!' ), 400);      
                    }
                   
                    if(strpos($FoxPostApi->error_msg, 'INVALID_PHONE') !== false){ 
                        wp_send_json_error(array('barcode' => 'Nem megfelelő telefonszám formátum!' ), 400);      
                    }
                }
                  
    		} elseif($result!==false) {
              //OK
    
              $order->update_meta_data( 'foxpost_wc_shipping_barcode', $result[ $orderId ] );
              $order->update_meta_data( '_foxpost_wc_shipping_status', 1 );        
              $order->update_meta_data( '_foxpost_wc_shipping_error', '' );          
              $order->save();            
              
              wp_send_json_success(array('barcode' => $result[ $orderId ] ));
                          
            } else {    
              $this->logger->log_e( $result );  
              wp_send_json_error("Error");
    		}           
        
        }            
       wp_send_json_error("Error");           
    } //end get_parcel_label
    
/*    
	//Meta box on order page
	public function add_metabox( $post_type, $post ) {  
		$order = wc_get_order($post->ID);
        $is_foxpost_parcel = metadata_exists('post', $order->get_id(), '_foxpost_wc_shipping_method');
        
		if($order && $is_foxpost_parcel) {  
				add_meta_box('_foxpost_wc_shipping_barcode', __('Tracking informations','foxpost-shipping-method'), array( $this, 'render_tracking_metabox_content' ), 'shop_order', 'side', 'foxpost-shipping-method');
		}
	}  
	//Render metabox content
	public function render_tracking_metabox_content($post) {
		$order = wc_get_order($post->ID);

        $value = get_post_meta( $post->ID, '_tracking_box', true );
        $text = ! empty( $value ) ? esc_attr( $value ) : '';
        echo '<input type="text" name="tracking_box" id="tcg_tracking_box" value="' . $text . '" />';
        echo '<input type="hidden" name="tracking_box_nonce" value="' . wp_create_nonce() . '">';
    }   
*/   

    function foxpost_wc_shipping_bulk_actions( $actions ) {
        $actions['foxpost_wc_shipping_export_api'] = __( 'Foxpost: Create & print labels' , 'foxpost-shipping-method');
        $actions['foxpost_wc_shipping_export_csv'] = __( 'Foxpost: Export parcels to CSV file' , 'foxpost-shipping-method');
        return $actions;
    }
    
    function foxpost_wc_shipping_handle_bulk_action_edit_shop_order( $redirect_to, $action, $post_ids ) {
        //echo "foxpost_wc_shipping_handle_bulk_action_edit_shop_order: $action"; print_r($post_ids);exit;    
        $filename = '';
        if ( $action !== 'foxpost_wc_shipping_export_api' && $action !== 'foxpost_wc_shipping_export_csv' )
            return $redirect_to; // Exit
        
        $path = wp_upload_dir( null, false );
        
        $errors = array_flip($post_ids);    
           
        $parcels = $processed_ids = array();
        foreach ( $post_ids as $post_id ) {
            $order = wc_get_order( $post_id );           
            $is_foxpost_parcel = $this->hpos->is_foxpost_parcel($order->get_id());
            if (!$is_foxpost_parcel){
                /* translators: %s: Order number */
                $errors[$post_id] = sprintf(__("The order #%s is not Foxpost parcel!"), $post_id, 'foxpost-shipping-method');
                continue;           
            } 

            $status  = $this->hpos->get_order_metadata($order, '_foxpost_wc_shipping_status', true);      
            $barcode = $this->hpos->get_order_metadata($order, 'foxpost_wc_shipping_barcode', true);
            //echo "$post_id: $status, $barcode \n";
            
            
            if ( trim($barcode)!='' && get_option('foxpost_wc_shipping_reparcel')=='no' ){                 
                /* translators: %s: Order number */
                $errors[$post_id] = sprintf(__("The order #%s has ParcelId: %s!"), $post_id, $barcode, 'foxpost-shipping-method');
            }elseif(0!=$status && get_option('foxpost_wc_shipping_reparcel')=='no' ){
                /* translators: %s: Number of processed order */
                $errors[$post_id] = 
                sprintf(__("The order #%s is not exported to CSV or sended to API! Maybe exported before."), $post_id, $barcode, 'foxpost-shipping-method').' ';
                /* translators: %s: Title of Woocommerce settings section */
                $errors[$post_id] .= 
                sprintf(__('See the "%s" section in settings.', 'foxpost-shipping-method'), __('Export CSV and send to Foxpost API', 'foxpost-shipping-method'));      
            }else{
                $processed_ids[] = $order->get_id();
                $parcels[] = $this->_convOrder2ParcelData($order);                 
            }
            
           /* 
            if ( (0==$status || get_option('foxpost_wc_shipping_reparcel')=='yes')  && trim($barcode)==''){              
                $processed_ids[] = $order->get_id();
                $parcels[] = $this->_convOrder2ParcelData($order);            
            }else{
                $errors[$post_id] = sprintf(__("The order number #%s has ParcelId: %s"), $post_id, $barcode, 'foxpost-shipping-method');//"This order has ParcelId #$post_id: $barcode!";
            }
            */
        } 
        //print_r($processed_ids);          print_r($errors);exit;
       
        //$FoxPostApi = new FoxPostApi(6);          
        //$FoxPostApi->setCred( get_option('foxpost_wc_shipping_username'), get_option('foxpost_wc_shipping_password'), get_option('foxpost_wc_shipping_apikey') );
        //$FoxPostApi->setTmpDir( $path['basedir'].DIRECTORY_SEPARATOR.'foxpost-wc-shipping'.DIRECTORY_SEPARATOR );
        $FoxPostApi = $this->getAPI(); 
         
        if ( $action == 'foxpost_wc_shipping_export_api' ){
            $result = $FoxPostApi->createParcel($parcels);
        }
        if ( $action == 'foxpost_wc_shipping_export_csv' ){          

            $filename = 'foxpost-export-'.time().'.csv';                    
            $CSV_file = $path['basedir'].DIRECTORY_SEPARATOR.'foxpost-wc-shipping'.DIRECTORY_SEPARATOR.'labels'.DIRECTORY_SEPARATOR.$filename;     
            
            $options = include(dirname(plugin_dir_path(__FILE__)).'/config.php');
            $FoxPostApi->setConfig($options);
            
            $result = $FoxPostApi->createCSV($parcels, 'labels'.DIRECTORY_SEPARATOR.$filename );  
            //print_r($parcels); print_r($result);   print_r($FoxPostApi);  exit;    
        }        
        
        //log partial errors
        //echo $FoxPostApi->error_msg;
        
         
        if ($FoxPostApi->error===false && $result!==false){ 
          //OK
          foreach($result as $orderId=>$barcode){
            unset($errors[$orderId]);
            $order = wc_get_order( $orderId );
            $order->update_meta_data( 'foxpost_wc_shipping_barcode', $barcode );    
            $order->update_meta_data( '_foxpost_wc_shipping_error', '' );    
            $order->update_meta_data( '_foxpost_wc_shipping_status', 2 );  //csalunk            
            $order->save();               
          }
                         
          //Get Labels from Foxpost API 
          if ( $action == 'foxpost_wc_shipping_export_api' )
            $filename = $FoxPostApi->parcelLabel( array_values($result), get_option('foxpost_wc_shipping_label_size') );//  var_dump($parcel);   var_dump($FoxPostApi);        
        
		} 
     
        //Errors
        foreach($errors as $orderId=>$message){         
            $order = wc_get_order( $orderId );
            //$order->update_meta_data( '_foxpost_wc_shipping_status', 0 );        
            $order->update_meta_data( '_foxpost_wc_shipping_error', __( "Error when processing order #$orderId error: $message" ) , 'foxpost-shipping-method');          
            $order->save(); 
            $this->logger->log_w( "Error when processing order #$orderId error: $message" );   
        }        
        
                 
        //print_r( ($errors) );exit('last');
        
        Foxpost_Wc_Shipping::setToSession('export_link',        $path['baseurl'].'/foxpost-wc-shipping/labels/'.$filename);
        Foxpost_Wc_Shipping::setToSession('export_processed',   $processed_ids);
        Foxpost_Wc_Shipping::setToSession('export_errors',      $errors);
        
        return $redirect_to = add_query_arg( array(
            $action             => '1',
            //'processed_count'   => count( $processed_ids ),
            //'processed_ids'     => implode( ',', $processed_ids ),
            //'error_count'       => count( $errors ),
            //'error_ids'         => implode( ',', array_keys($errors) ),
            //'pdf_location'      => $path['baseurl'].'/foxpost-wc-shipping/labels/'.$filename,
        ), $redirect_to );       
            
    }
    
    /**
     * 
     * 
     * 
     * 
     */ 
    function foxpost_wc_shipping_admin_notice() {
        //print_r($_REQUEST);exit("foxpost_wc_shipping_admin_notice");
        if ( empty( $_REQUEST['foxpost_wc_shipping_export_api'] ) && empty( $_REQUEST['foxpost_wc_shipping_export_csv']) ) return; // Exit
   
    
    
        $processed_ids      =   Foxpost_Wc_Shipping::getFromSession('export_processed', array(), true);//sanitize_text_field( $_REQUEST['processed_ids'] );
        $processed_count    =   count($processed_ids);//intval( $_REQUEST['processed_count'] );
        
        $errors             =   Foxpost_Wc_Shipping::getFromSession('export_errors', array(), true); //sanitize_text_field( $_REQUEST['error_ids'] );   
        
        $link               =   Foxpost_Wc_Shipping::getFromSession('export_link', null, true);//anitize_text_field( $_REQUEST['pdf_location'] );  
               
   
        //Bad  
        foreach ($errors as $error=>$msg){    
          echo( '<div id="message" class="notice notice-error is-dismissible"><p>' .esc_html($msg).'</p></div>' );                
        }
                              
        //Good
        $label = ( !empty( $_REQUEST['foxpost_wc_shipping_export_api'] ) ) ? 'Print label' : 'Download CSV file';
        
        /* translators: %s: Count of processed orders */
        $n = _n( __('Processed %s order.', 'foxpost-shipping-method'), __('Processed %s orders.', 'foxpost-shipping-method'), $processed_count, 'foxpost_wc_shipping');
        if ($processed_count>0) $n .= ' <a href="'.$link.'" target="_blank">'.__($label, 'foxpost-shipping-method').'</a>';       
        printf( '<div id="message" class="notice notice-success is-dismissible"><p>' . $n . '</p></div>', $processed_count );  //notice-success                 
            
    }
    
    /**
     * Settings link on plugin page
     * 
     */ 
    public function add_plugin_link( $plugin_actions, $plugin_file ) {  
        $new_actions = array();   

        if ( 'foxpost-wc-shipping/foxpost-wc-shipping.php' === $plugin_file ) {
            $new_actions['cl_settings'] = sprintf( '<a href="%s">'.__( 'Settings', 'foxpost-shipping-method' ).'</a>', esc_url( admin_url( 'admin.php?page=wc-settings&tab=foxpost_wc_shipping' ) ) );
        }

        return array_merge( $new_actions, $plugin_actions );   
    }

    /**
     * Add trigger action
     * 
     */ 
    public static function wc_get_order_statuses(){
        
        $no_action = array( 'no-action'=> __('Dont happening anything', 'foxpost-shipping-method'));
    
        return array_merge($no_action, wc_get_order_statuses());
    }


    public static function admin_order_item_values($product, $item, $item_id = null){
    }    
    

    /**
     * Make FoxApi compatible array from WooCommerce order object
     * 
     * 
     * 
     * 
     */ 
    private function _convOrder2ParcelData($order){
    
        $data = array();

        $shipping_method = ( 'apt' == $this->hpos->get_order_metadata($order, '_foxpost_wc_shipping_method', true) && $this->hpos->get_order_metadata($order, '_foxpost_wc_shipping_apt_id', true))? 'apt' : 'hd';
        
        //uniqueBarcode
        
        if ( 'cod' == $order->get_payment_method() ) $data['cod'] = $order->get_total();   
        //$data['deliveryNote'] = substr( get_bloginfo('url', 'raw' ).' #'.$order->get_id().' '.$order->get_customer_note(), 0, 50);
        $data['deliveryNote'] = substr($order->get_customer_note(), 0, 50);
        $data['recipientAddress'] = $order->get_shipping_address_1().' '.$order->get_shipping_address_2();
        $data['recipientCity'] = $order->get_shipping_city();
        $data['recipientEmail'] = ( '' != $this->hpos->get_order_metadata($order, '_shipping_email', true) ) ? $this->hpos->get_order_metadata($order, '_shipping_email', true) : $order->get_billing_email(); 
        $data['recipientPhone'] = ( '' != $this->hpos->get_order_metadata($order, '_shipping_phone', true) ) ? $this->hpos->get_order_metadata($order, '_shipping_phone', true) : $order->get_billing_phone();        
        $data['recipientZip'] = $order->get_shipping_postcode();       
        $data['comment'] = substr( get_bloginfo('url', 'raw' ).' #'.$order->get_id(), 0, 50 );//raw|name
        $data['refCode'] = $order->get_id();//$order->get_order_key();
        
        $data['recipientName']  = (!empty($order->get_shipping_last_name())) ? $order->get_shipping_last_name() : $order->get_billing_last_name();
        $data['recipientName'] .= ' ';
        $data['recipientName'] .= (!empty($order->get_shipping_first_name())) ? $order->get_shipping_first_name() : $order->get_billing_first_name();
        
        if ( 'apt' == $shipping_method ){
            $data['destination'] = $this->hpos->get_order_metadata($order, '_foxpost_wc_shipping_apt_id', true);  
        }else{
            $data['recipientName'] .= ' ';
            $data['recipientName'] .= (!empty($order->get_shipping_company())) ? $order->get_shipping_company() : $order->get_billing_company();
        } 
  
        $data['size'] = $this->hpos->get_order_metadata($order, 'foxpost_wc_shipping_parcel_size', true);//Foxpost_Wc_Shipping_Method::getDefaultParcelSize(); 
        $data['source'] = 'wordpress_'.FOXPOST_WC_SHIPPING_VERSION;
        //print_r($data);exit;                                                               
        return $data;
    }
    
    
    
    /**
     * Change shipping_address coloum on Orders page
     * 
     * 
     */ 
    public function customizing_orders_columns( $columns ){
        $new_columns = [];
        
        foreach ( $columns as $key => $column ) {
            if( $key === 'shipping_address' ) {
                $new_columns['shipping_addr_repl'] = $column;
            } else {
                $new_columns[$key] = $column;
            }
        }
        return $new_columns;
    }
    
    /**
     * Configure FoxPostApi for this enviromment 
     * 
     * @param $loglevel API log level
     * @return object API object
     */ 
    private function getAPI(int $loglevel=0){
        $loglevel = ($loglevel>0) ? $loglevel : $this->API_LOG_LEVEL;
        if( get_option('foxpost_wc_shipping_api_log_level')!=false ) $loglevel = get_option('foxpost_wc_shipping_api_log_level'); //Configuration::get('FOXPOST_API_LOG_LEVEL');
        
        if ( is_null($this->FoxPostApi) || ( ! $this->FoxPostApi instanceof FoxPostApi ) ){
            $FoxPostApi = new FoxPostApi($loglevel); 
                        
            $p = wp_upload_dir( null, false );                
            $FoxPostApi->setTmpDir( $p['basedir'].DIRECTORY_SEPARATOR.'foxpost-wc-shipping'.DIRECTORY_SEPARATOR );

            $FoxPostApi->setCred( get_option('foxpost_wc_shipping_username'), get_option('foxpost_wc_shipping_password'), get_option('foxpost_wc_shipping_apikey') );
                        
            global $woocommerce, $wp_version; 
            $FoxPostApi->setUserAgent(array('WP'=>$wp_version, 'WooCommerce'=>$woocommerce->version));
            
            $this->FoxPostApi = $FoxPostApi;      
        } 
        return $this->FoxPostApi; 
    }
    
     
    /**
     * Change shipping_address coloum on Orders page
     * 
     * @see WC_Admin_List_Table, WC_Admin_List_Table_Orders, ListTable::column_shipping_address
     */ 
    public function set_custom_shipping_address_content_replacement( $column, $order = null ) {
        global $the_order, $post;
        $order = $order ?? $the_order;

        if ( 'shipping_addr_repl' === $column ) {
           
           //Ha nem Fox-os az eredeti kinézet
            $is_foxpost_parcel = $this->hpos->is_foxpost_parcel($order->get_id());
            if (!$is_foxpost_parcel){
                $ListTable = new Automattic\WooCommerce\Internal\Admin\Orders\ListTable();
                echo $ListTable->column_shipping_address( $order );             
                return;
            };  
        

      
    		$address = $order->get_formatted_shipping_address();
            //$address = $order->get_address( 'shipping' );
    
    		if ( $address ) {
    			echo '<a target="_blank" href="' . esc_url( $order->get_shipping_address_map_url() ) . '">' . esc_html( preg_replace( '#<br\s*/?>#i', ', ', $address ) ) . '</a>';
    			if ( $order->get_shipping_method() ) {
    				echo '<span class="description">' . sprintf( esc_html__( 'via %s', 'foxpost-shipping-method' ), esc_html( $order->get_shipping_method() ) ) . '</span>';
    			}
    		} else {
    			echo '&ndash;';
    		}
        
            echo  '<p>'.( empty($order->get_meta('foxpost_wc_shipping_barcode')) ? 
                            __('Parcel ID not exist', 'foxpost-shipping-method') : 
                            '<a href="'.sprintf(FoxPostApi::TRACEURL, $order->get_meta('foxpost_wc_shipping_barcode')).'" target="_blank">' . esc_html($order->get_meta('foxpost_wc_shipping_barcode')) . '</a>'
                        ) .'</p>';
                            
                                
            echo '<p>'.__( $this->hpos->get_order_metadata($order,'_foxpost_wc_shipping_parcel_status_name', true), 'foxpost-shipping-method' ).'</p>';
        }                                                                       
    }     
    
    
}
