<?php

/**
 * Fired when the plugin is uninstalled.
 *
 * When populating this file, consider the following flow
 * of control:
 *
 * - This method should be static
 * - Check if the $_REQUEST content actually is the plugin name
 * - Run an admin referrer check to make sure it goes through authentication
 * - Verify the output of $_GET makes sense
 * - Repeat with other user roles. Best directly by using the links/query string parameters.
 * - Repeat things for multisite. Once for a single site in the network, once sitewide.
 *
 * This file may be updated more in future version of the Boilerplate; however, this is the
 * general skeleton and outline for how the file should work.
 *
 * For more information, see the following discussion:
 * https://github.com/tommcfarlin/WordPress-Plugin-Boilerplate/pull/123#issuecomment-28541913
 *
 * @link       https://foxpost.hu
 * @since      1.0.0
 *
 * @package    Foxpost_Wc_Shipping
 *    activate_plugins
      edit_plugins
      install_plugins
      update_plugins
      delete_plugins
      upload_plugins
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}


global $wpdb;

if ( is_admin() && empty($_REQUEST['foxpost-wc-shipping']) && current_user_can( 'delete_plugins' ) )  {
	// Delete admin notices
	//delete_metadata( 'user', 0, 'foxpost_wc_shipping_admin_notices', '', true );   

	// Delete post meta data  
	//$wpdb->query("DELETE FROM {$wpdb->prefix}postmeta WHERE meta_key LIKE 'foxpost\_wc\_shipping%' OR meta_key LIKE '\_foxpost\_wc\_shipping%';");
    
	//Delete options                 
	//$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE 'foxpost\_wc\_shipping%';");

    //$upload_dir = wp_upload_dir();       
    //fws_remove_directory($upload_dir['basedir'] . '/foxpost-wc-shipping'); 
}



function fws_remove_directory($path) {
	global $wp_filesystem;
	$files = glob($path . '/*');
	foreach ($files as $file) {
		is_dir($file) ? fws_remove_directory($file) :  wp_delete_file($file);
	}
	$wp_filesystem->rmdir($path);

	return;
}
