<?php
if (!defined('ABSPATH')) {
    die;
}
/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://foxpost.hu
 * @since      1.0.0
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/includes
 * @author     Foxpost.hu <b2chelpdesk@foxpost.hu>
 */
class Foxpost_Wc_Shipping_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'foxpost-shipping-method',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
