<?php

/**
 * Fired during plugin activation
 *
 * @link       https://foxpost.hu
 * @since      1.0.0
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/includes
 */
if (!defined('ABSPATH')) {
    die;
}
/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/includes
 * @author     Foxpost.hu <b2chelpdesk@foxpost.hu>
 */
class Foxpost_Wc_Shipping_Activator {

	/**
	 * Activate!
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
        self::add_min_version_notice();
		global $wp_filesystem;
        $upload_dir = wp_upload_dir();
        
		$files = array(
			array(
				'base' => $upload_dir['basedir'] . '/foxpost-wc-shipping',
				'file' => 'index.html',
				'content' => ''
			),
			array(
				'base' => $upload_dir['basedir'] . '/foxpost-wc-shipping/labels',
				'file' => 'index.html',
				'content' => ''
			),
			array(
				'base' => $upload_dir['basedir'] . '/foxpost-wc-shipping/logs',
				'file' => 'index.html',
				'content' => ''
			)
		);

		foreach ( $files as $file ) {
			if ( wp_mkdir_p( $file['base'] ) && ! file_exists( trailingslashit( $file['base'] ) . $file['file'] ) ) {
				if ( $file_handle =  $wp_filesystem->get_contents( trailingslashit( $file['base'] ) . $file['file']) ) {
					$wp_filesystem->put_contents( $file_handle, $file['content'] );
				}
			}
		}
        
        update_option( 'foxpost_wc_shipping_map_enabled', 'yes', true );
        update_option( 'foxpost_wc_shipping_version', FOXPOST_WC_SHIPPING_VERSION, true );   
	}
    
    /**
     * Add admin notice, if WordPress or WooCommerce not compatible.
     * Active or not is not here tested.
     * 
     */ 
	private static function add_min_version_notice() {           
        //WooCommerce
        if ( !defined('WC_VERSION') ||  
             version_compare( WC_VERSION, FOXPOST_WC_SHIPPING_MIN_WOO_VERSION, '<' ) ||  
             ! class_exists('WooCommerce') ||
             ! in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins'))) 
             //! is_plugin_active('woocommerce/woocommerce.php') ||
             //! is_plugin_active_for_network('woocommerce/woocommerce.php') ||
             //! is_plugin_active('__woocommerce/woocommerce.php') 
             //! is_plugin_active_for_network('__woocommerce/woocommerce.php')  
        ) {
			/* translators: %s: Minimum required version of WooCommerce */
			$wc_err_message = sprintf(__('"FOXPOST - Packeta Group" requires WooCommerce %s or higher!', 'foxpost-shipping-method'), FOXPOST_WC_SHIPPING_MIN_WOO_VERSION);
            wp_die( $wc_err_message);
        };
    
                                           
        //PHP & Wordpress
		if ( version_compare( phpversion(), FOXPOST_WC_SHIPPING_MIN_PHP_VERSION, '<' ) || 
             version_compare( get_bloginfo( 'version' ), FOXPOST_WC_SHIPPING_MIN_WP_VERSION, '<' )
             ) {
				/* translators: %s: Minimum required version of Wordpress */
				$wp_err_message = sprintf(__('"FOXPOST - Packeta Group" requires WordPress %s or higher!', 'foxpost-shipping-method'), FOXPOST_WC_SHIPPING_MIN_WP_VERSION);
			     wp_die( $wp_err_message );
		};
        
	}     

} //end class
