<?php
if (!defined('ABSPATH')) {
    die;
}

/**
 * Class Foxpost_Wc_Shipping_Autoloader
 */
class Foxpost_Wc_Shipping_Autoloader {
    /**
     * @var string
     *
     * @since 1.0.0
     */
    private $plugin_namespace = 'Foxpost_Wc_Shipping';
    /**
     * @var string
     *
     * @since 1.0.0
     */
    private $plugin_path;

    /**
     *  Constructor.
     *
     * @since 1.0.0
     *
     * @param string $plugin_path
     */
    public function __construct($plugin_path)
    {
        $this->plugin_path = $plugin_path;

        $this->register();
    }

    /**
     * Unregister autoloader.
     *
     * @since 1.0.0
     */
    public function unregister()
    {
        spl_autoload_unregister(array($this, 'autoloader'));
    }

    /**
     * Register autoloader.
     *
     * @since 1.0.0
     *
     * @param bool $prepend
     */
    public function register($prepend = true)
    {
        spl_autoload_register(array($this, 'autoloader'), true, $prepend);
    }

    /**
     * @param string $class
     *
     * @since 1.0.0
     */
    public function autoloader($class)
    {    
        $path_parts = explode('\\', $class);      echo "class:{$class}\n"                    ;

        if (count($path_parts) <= 1) {      
            return;
        }

        $start = array_values($path_parts)[0];      echo "start:{$start}\n"                    ;

        if ($start !== $this->plugin_namespace) {       
            return;
        }

        $file = $this->plugin_path;              echo "file:{$file}\n"                    ;

        $end = array_pop($path_parts);                echo "end:{$end}\n"                    ;

        foreach ($path_parts as $part) {
            if ($part !== $this->plugin_namespace) {
                preg_match_all('!([A-Z][A-Z0-9]*(?=$|[A-Z][a-z0-9])|[A-Za-z][a-z0-9]+)!', $part, $matches);

                $parts = $matches[0];

                $part = implode('-', $parts);

                $file .= strtolower($part) . '/';
            }
        }

        foreach (
            array(
                'class-',
                'abstract-',
                ''
            ) as $file_name_start
        ) {
            preg_match_all('!([A-Z][A-Z0-9]*(?=$|[A-Z][a-z0-9])|[A-Za-z][a-z0-9]+)!', $end, $matches);

            $end = $matches[0];

            $end = implode('-', $end);

            $file_ending = $file_name_start . strtolower($end) . '.php';      echo "{$file}{$file_ending}";

            if (is_file($file . $file_ending)) {
                include_once( $file . $file_ending );

                return;
            }
        }
    }
}
