<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://foxpost.hu
 * @since      1.0.0
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/admin/partials
 */



if (!defined('ABSPATH')) {
    exit();
}                                                    
                                              
?>                                                                                  
<div id="div-iframe"><iframe id="export_download_frame" width="0" height="0" style="display: none;"></iframe></div>

<div class="address">   
      <p><strong><?php echo esc_html__('Shipping mode:', 'foxpost-shipping-method') ?></strong> <?php echo esc_html($method_str);?></p>                            
      <!--p><strong>Átvételi pont:</strong> <a href="#">475809</a></p-->      
      <p><strong><?php echo esc_html__('Parcel number:', 'foxpost-shipping-method') ?></strong> </span><a href="<?php echo esc_attr($tracelink);?>" target="_blank"><span class="foxpost_wc_shipping_barcode"><?php echo esc_html($barcode);?></span></a> - <span class="foxpost_wc_shipping_status">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></p>
      <button type="button" class="button foxpost_wc_shipping_label_or_print" id="foxpost_wc_shipping_label_or_print">
      <?php if('' == $barcode): ?>
      <?php echo esc_html__('Request label', 'foxpost-shipping-method') ?>
      <?php else: ?>
      <?php echo esc_html__('Print label', 'foxpost-shipping-method') ?>
      <?php endif; ?> 
      </button>
</div>

</script>