(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });                              
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */
    $( window ).load(function() {    
    
      if ( $('.shipping_addr_repl').length){
        $('.shipping_addr_repl').addClass( "shipping_address" );
      }
      
      if ( $('.column-shipping_addr_repl').length){
        $('.column-shipping_addr_repl').addClass( "column-shipping_address" );
      }

      var $clock = $('#foxpost-wc-shipping-clock')
      .on('update.countdown', function(event) {
        var format = '%H:%M:%S';
        if(event.offset.totalDays > 0) {
          format = '%-d day%!d ' + format;
        }
        if(event.offset.weeks > 0) {
          format = '%-w week%!w ' + format;
        }
        $(this).html(event.strftime(format));
      })
      .on('finish.countdown', function(event) {
          wc_on();
      });  


      if ( $('#foxpost-wc-shipping-syncparcel').length){
          var time = parseInt($( '#foxpost-wc-shipping-syncparcel' ).attr('data-time')) ;     
          if (time==0){
              wc_on();
          }else{
              var selectedDate = new Date().valueOf() + (time * 1000);
              wc_off(selectedDate);
          }  
      }
        
      function wc_on(){
        $( '#foxpost-wc-shipping-syncparcel' ).attr('disabled',false);                                        
        $clock.html('Frissítés most!');
                   
        $( '#foxpost-wc-shipping-syncparcel' ).on( 'click', function() {  
            event.preventDefault();  
        
            var r = $.post( '/wp-admin/admin-ajax.php', {
                action: 'foxpost_wc_shipping_sync_parcel_status',
                dataType: 'json'
            });
            r.done(function( data ) {    
              const listTable = $('.wp-list-table');
              if(listTable.length === 0) return;
              $.get(window.location.href).then((data)=>{
                const newTable = $(data).find('.wp-list-table');
                listTable.html(newTable.html())
              })    
              if ( parseInt(data.data.time)>0 ){
                var selectedDate = new Date().valueOf() + (parseInt(data.data.time) * 1000);
                wc_off(selectedDate);       
              }else{
               $( '#foxpost-wc-shipping-sync-message' ).fadeIn(3);
               $( '#foxpost-wc-shipping-sync-message' ).html(''); 
               $( '#foxpost-wc-shipping-sync-message' ).html(' '+data.data.message); 
               $( '#foxpost-wc-shipping-sync-message' ).fadeOut(3000);
              }       
            });
            
        });      
      }
      
      function wc_off(time){
          $( '#foxpost-wc-shipping-syncparcel' ).off( 'click' );
          $( '#foxpost-wc-shipping-syncparcel' ).attr('disabled','disabled');       
          $clock.countdown(time.toString());  
      }        
    
      
    });
     
})( jQuery );

