<?php

/**
 * 
 * The admin notice header content.
 *
 * @link       https://foxpost.hu/
 * @since      1.0.0
 *
 * @package    Foxpost_Wc_Shipping
 * @subpackage Foxpost_Wc_Shipping/admin
 */
 
defined( 'ABSPATH' ) || exit;

class Foxpost_Wc_Shipping_Admin_Notice
{

    //const DELTA_MIN = 5;  
     
    /**
     * constructor.
     */
    public function __construct()
    {
        global $pagenow; 
        if ('edit.php'==$pagenow && !empty($_REQUEST['post_type']) && $_REQUEST['post_type']=='shop_order' ) $this->parcels_update();
        // WooCommerce 9 compatibility
        if ('admin.php'==$pagenow && ($_REQUEST['page']=='wc-orders' && !isset($_REQUEST['action']))) $this->parcels_update();
        return;
    }


    public function parcels_update()
    {
        /* translators: %s: Time for next syncronization */
        $message = esc_html__(
            sprintf(
                'Foxpost: A következő automatikus frissítésig hátralévő idő: %s.', 
                human_time_diff( time(), Foxpost_Wc_Shipping::getNextParcelSyncTime())
            ),
            'foxpost-shipping-method' );

        $time_diff = time()-(int)Foxpost_Wc_Shipping::getLastParcelSyncTime();
        
        if ( $time_diff > Foxpost_Wc_Shipping::SYNC_MIN_MINUTE*60 ){
            $data_time = 0;
        }else{
            $data_time = (Foxpost_Wc_Shipping::SYNC_MIN_MINUTE*60-$time_diff);        
        }     
        
             
        $button = sprintf(
                '<a href="#" name="foxpost-wc-shipping-syncparcel" id="foxpost-wc-shipping-syncparcel" data-time="%d" class="button action"><span id="foxpost-wc-shipping-clock">%s</span></a><span id="foxpost-wc-shipping-sync-message"></span>', 
                $data_time,
                esc_html__( 'Frissítés most!' , 'foxpost-shipping-method')
        );         

        add_action( 'admin_notices',
            function() use ( $message, $button ) {
                echo '<div class="notice"><p><img src="/wp-content/plugins/foxpost-wc-shipping/images/icon-foxpost.svg"/>' . $message . ' ' . $button. '</p></div>';
            }
        );
        
    }

}

new Foxpost_Wc_Shipping_Admin_Notice();
