<?php

/**
 * FoxPost
 *
 * @author Foxpost <kovago.balazs@foxpost.hu>
 * @copyright 2022 FoxPost Zrt.
 * @license   See joined file licence.txt
 * @category  Module
 * @support   Support <b2chelpdesk@foxpost.hu>
 * @version   0.0.1
 * @link      https://www.foxpost.hu
 */


class FPPackage extends ObjectModel
{
    public $id_foxpost_package;
    public $id_order;
    public $id_carrier;
    public $shipping_method;
    public $parcel_size;
    public $operator_id;
    public $barcode;
    public $error;
    public $parcel_status;
    public $parcel_status_name;
    public $active;
    public $exported;
    public $printed;
    public $status;
    public $date_add;
    public $date_upd;

    public static $definition = array(
        'table' => 'foxpost_package',
        'primary' => 'id_foxpost_package',
        'fields' => array(
            'id_foxpost_package' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'id_order'          => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'id_carrier'        => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'shipping_method'   => array('type' => self::TYPE_STRING, 'validate' => 'isMessage', 'required' => true, 'size' => 3),
            'parcel_size'       => array('type' => self::TYPE_STRING, 'validate' => 'isMessage', 'size' => 3),
            'operator_id'       => array('type' => self::TYPE_STRING, 'validate' => 'isMessage', 'size' => 10),
            'barcode'           => array('type' => self::TYPE_STRING, 'validate' => 'isMessage', 'size' => 255),
            'error'             => array('type' => self::TYPE_STRING, 'validate' => 'isMessage', 'size' => 255),
            'parcel_status'     => array('type' => self::TYPE_STRING, 'validate' => 'isMessage', 'size' => 255),
            'parcel_status_name' => array('type' => self::TYPE_STRING, 'validate' => 'isMessage', 'size' => 255),
            'active'            => array('type' => self::TYPE_BOOL),
            'exported'          => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'printed'           => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'status'            => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'date_add'          => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            'date_upd'          => array('type' => self::TYPE_DATE, 'validate' => 'isDate')
        ),
    );

    public static function getFPPackageByOrderId($id_order)
    {
        $id_foxpost_package = \Db::getInstance()->getRow(
            'SELECT id_foxpost_package FROM `' . _DB_PREFIX_ . 'foxpost_package` WHERE `id_order`= ' . (int)$id_order . ' AND active=1'
        );
        if ($id_foxpost_package) {
            return new self($id_foxpost_package['id_foxpost_package']);
        } else {
            return false;
        }
    }


    public static function getShipmentInfoByOrderId($id_order)
    {
        return \Db::getInstance()->getRow(
            'SELECT * FROM `' . _DB_PREFIX_ . 'foxpost_package` WHERE `id_order`= ' . (int)$id_order . ' AND active=1'
        );
    }
    public static function updateParcelSizeByOrderId($id_order, $parcelsize)
    {
        \Db::getInstance()->execute("UPDATE " . _DB_PREFIX_ . "foxpost_package 
                SET parcel_size = '" . pSQL($parcelsize) . "', date_upd=NOW() WHERE active=1 AND id_order=" . (int)$id_order);
    }

    public static function setS1($id_order, $barcode)
    {
        \Db::getInstance()->execute("UPDATE " . _DB_PREFIX_ . "foxpost_package 
                SET status = 1, barcode = '" . $barcode . "', date_upd=NOW() WHERE active=1 AND id_order=" . (int)$id_order);
    }

    public static function setS2($barcode)
    {
        \Db::getInstance()->execute("UPDATE " . _DB_PREFIX_ . "foxpost_package 
                SET status = 2, printed = 1, date_upd=NOW() WHERE active=1 AND barcode='" . pSQL($barcode) . "'");
    }
}
